<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Admin\CancellationReason;

class CancellationReasonSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    protected $cancelation_reason = [
       [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Waiting for driver long Time',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Driver Drinked',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'compensate',
        'arrival_status' => 'after',
        'reason' => 'Driver Too Late',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'compensate',
        'arrival_status' => 'before',
        'reason' => 'Self Cancelation',
        'active' => 1,
        'company_key' => null,],

        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'User Cancelled',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'User Not Receive Calls',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'compensate',
        'arrival_status' => 'before',
        'reason' => 'Self Cancelation',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'compensate',
        'arrival_status' => 'after',
        'reason' => 'User Too Late',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'delivery',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Waiting for driver long Time',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'delivery',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Driver Drinked',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'delivery',
        'payment_type' => 'compensate',
        'arrival_status' => 'after',
        'reason' => 'Driver Too Late',
        'active' => 1,
        'company_key' => null,],
       [ 'user_type' => 'user',
         'transport_type' => 'delivery',
        'payment_type' => 'compensate',
        'arrival_status' => 'before',
        'reason' => 'Self Cancelation',
        'active' => 1,
        'company_key' => null,],
        ['user_type' => 'driver',
         'transport_type' => 'delivery',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'User Cancelled',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'delivery',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'User Not Receive Calls',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'delivery',
        'payment_type' => 'compensate',
        'arrival_status' => 'before',
        'reason' => 'Self Cancelation',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'delivery',
        'payment_type' => 'compensate',
        'arrival_status' => 'after',
        'reason' => 'User Too Late',
        'active' => 1,
        'company_key' => null,],

        //
        [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Alternative Transportation',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'user',
         'transport_type' => 'delivery',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Financial Reasons',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Vehicle Issues',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Personal Reasons',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'user',
         'transport_type' => 'delivery',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Personal Reasons',
        'active' => 1,
        'company_key' => null,],

        [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Safety Concerns',
        'active' => 1,
        'company_key' => null,],

        [ 'user_type' => 'user',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'weather Conditions',
        'active' => 1,
        'company_key' => null,],

        //
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Vehicle Issues',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Traffic or Road Conditions',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Passenger No-Show',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'after',
        'reason' => 'Inappropriate Passenger Behavior',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
         'transport_type' => 'taxi',
        'payment_type' => 'free',
        'arrival_status' => 'before',
        'reason' => 'Schedule Conflicts',
        'active' => 1,
        'company_key' => null,],
        [ 'user_type' => 'driver',
        'transport_type' => 'taxi',
       'payment_type' => 'free',
       'arrival_status' => 'before',
       'reason' => 'weather Conditions',
       'active' => 1,
       'company_key' => null,],
        [ 'user_type' => 'driver',
        'transport_type' => 'taxi',
       'payment_type' => 'free',
       'arrival_status' => 'after',
       'reason' => 'Miscommunication ',
       'active' => 1,
       'company_key' => null,],

    ];

    public function run()
    {
      $created_params = $this->cancelation_reason;

      $value = CancellationReason::first();

      if(is_null($value))
      {
        foreach ($created_params as $reason)
        {
          CancellationReason::create($reason);
        }
      }
      // else {
      //   foreach ($created_params as $reason)
      //   {
      //     $value->update($reason);
      //   }

      // }

    }
}
